/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Sound;

public abstract class SoundState
extends LeafState {
    private int boundingLeaf;
    private int mediaContainer;

    public SoundState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.boundingLeaf = controller.getSymbolTable().addReference(((Sound)this.node).getSchedulingBoundingLeaf());
            this.mediaContainer = controller.getSymbolTable().addReference(((Sound)this.node).getSoundData());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        Sound sound = (Sound)this.node;
        dataOutput.writeBoolean(sound.getContinuousEnable());
        dataOutput.writeBoolean(sound.getEnable());
        dataOutput.writeFloat(sound.getInitialGain());
        dataOutput.writeInt(sound.getLoop());
        dataOutput.writeFloat(sound.getPriority());
        dataOutput.writeBoolean(sound.getReleaseEnable());
        dataOutput.writeInt(this.boundingLeaf);
        this.control.writeBounds(dataOutput, sound.getSchedulingBounds());
        dataOutput.writeInt(this.mediaContainer);
        dataOutput.writeBoolean(sound.getMute());
        dataOutput.writeBoolean(sound.getPause());
        dataOutput.writeFloat(sound.getRateScaleFactor());
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        Sound sound = (Sound)this.node;
        sound.setContinuousEnable(dataInput.readBoolean());
        sound.setEnable(dataInput.readBoolean());
        sound.setInitialGain(dataInput.readFloat());
        sound.setLoop(dataInput.readInt());
        sound.setPriority(dataInput.readFloat());
        sound.setReleaseEnable(dataInput.readBoolean());
        this.boundingLeaf = dataInput.readInt();
        sound.setSchedulingBounds(this.control.readBounds(dataInput));
        this.mediaContainer = dataInput.readInt();
        sound.setMute(dataInput.readBoolean());
        sound.setPause(dataInput.readBoolean());
        sound.setRateScaleFactor(dataInput.readFloat());
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.mediaContainer);
    }

    public void buildGraph() {
        ((Sound)this.node).setSchedulingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        ((Sound)this.node).setSoundData((MediaContainer)this.control.getSymbolTable().getJ3dNode(this.mediaContainer));
        super.buildGraph();
    }
}

